//
//  AHKMultiValue.m
//  AH-K3001V Utilities
//
//  Created by Fujidana on Fri Feb 18 2005.
//  Copyright (c) 2005 Fujidana Kobo. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKMultiValue.h"


const int kMaxLengthOfPhone = 32;
const int kMaxLengthOfEmail = 64;


@implementation AHKMultiValue

+ (void)initialize
{
	[self setKeys:[NSArray arrayWithObjects:@"firstLabel", @"secondLabel", @"thirdLabel", @"indexForPreferredValue", nil] triggerChangeNotificationsForDependentKey:@"preferredLabel"];
	[self setKeys:[NSArray arrayWithObjects:@"firstValue", @"secondValue", @"thirdValue", @"indexForPreferredValue", nil] triggerChangeNotificationsForDependentKey:@"preferredValue"];
	
	[self setKeys:[NSArray arrayWithObject:@"preferredLabel"] triggerChangeNotificationsForDependentKey:@"firstLabel"];
	[self setKeys:[NSArray arrayWithObject:@"preferredLabel"] triggerChangeNotificationsForDependentKey:@"secondLabel"];
	[self setKeys:[NSArray arrayWithObject:@"preferredLabel"] triggerChangeNotificationsForDependentKey:@"thirdLabel"];
	[self setKeys:[NSArray arrayWithObject:@"preferredValue"] triggerChangeNotificationsForDependentKey:@"firstValue"];
	[self setKeys:[NSArray arrayWithObject:@"preferredValue"] triggerChangeNotificationsForDependentKey:@"secondValue"];
	[self setKeys:[NSArray arrayWithObject:@"preferredValue"] triggerChangeNotificationsForDependentKey:@"thirdValue"];
}

#pragma mark implementation methods for NSCoding

- (id)initWithCoder:(NSCoder *)coder
{
	self = [super init];
	if (self != nil) {
		[self setFirstLabel:[coder decodeIntForKey:@"firstLabelIndex"]];
		[self setFirstValue:[coder decodeObjectForKey:@"firstValue"]];
		[self setSecondLabel:[coder decodeIntForKey:@"secondLabelIndex"]];
		[self setSecondValue:[coder decodeObjectForKey:@"secondValue"]];
		[self setThirdLabel:[coder decodeIntForKey:@"thirdLabelIndex"]];
		[self setThirdValue:[coder decodeObjectForKey:@"thirdValue"]];
		[self setIndexForPreferredValue:[coder decodeIntForKey:@"indexForPreferredValue"]];
	}
	return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
//	[super encodeWithCoder:coder]; // superclass NSObject does not implement this method.
	
	[coder encodeInt:firstLabel forKey:@"firstLabelIndex"];
	[coder encodeObject:firstValue forKey:@"firstValue"];
	[coder encodeInt:secondLabel forKey:@"secondLabelIndex"];
	[coder encodeObject:secondValue forKey:@"secondValue"];
	[coder encodeInt:thirdLabel forKey:@"thirdLabelIndex"];
	[coder encodeObject:thirdValue forKey:@"thirdValue"];
	[coder encodeInt:indexForPreferredValue forKey:@"indexForPreferredValue"];
}

#pragma mark implementation methods for NSCopying
- (id)copyWithZone:(NSZone *)zone
{
    id newObject = [[[self class] allocWithZone:zone] init];
	
	if (newObject != nil) {
		[newObject setFirstLabel:[self firstLabel]];
		[newObject setFirstValue:[self firstValue]];
		[newObject setSecondLabel:[self secondLabel]];
		[newObject setSecondValue:[self secondValue]];
		[newObject setThirdLabel:[self thirdLabel]];
		[newObject setThirdValue:[self thirdValue]];
		[newObject setIndexForPreferredValue:[self indexForPreferredValue]];
	}
	return newObject;
}

#pragma mark initialization and deallocation methods

- (id)init
{
	self = [super init];
	if (self != nil) {
		[self setFirstLabel:0];
		[self setFirstValue:nil];
		[self setSecondLabel:0];
		[self setSecondValue:nil];
		[self setThirdLabel:0];
		[self setThirdValue:nil];
	}
	return self;
}

- (void)dealloc
{
	[self setFirstValue:nil];
	[self setSecondValue:nil];
	[self setThirdValue:nil];
	
	[super dealloc];
}

#pragma mark accessor methods

- (int)firstLabel
{
	return firstLabel;
}

- (void)setFirstLabel:(int)value
{
	firstLabel = value;
}

- (NSString *)firstValue
{
	return firstValue;
}

- (void)setFirstValue:(NSString *)value
{
	if (firstValue != value) {
		[firstValue release];
		firstValue = [value copy];
	}
}

- (BOOL)validateFirstValue:(id *)ioValue error:(NSError **)outError
{
	return [self validateValue:ioValue error:outError];
}


- (int)secondLabel
{
	return secondLabel;
}

- (void)setSecondLabel:(int)value
{
	secondLabel = value;
}

- (NSString *)secondValue
{
	return secondValue;
}

- (void)setSecondValue:(NSString *)value
{
	if (secondValue != value) {
		[secondValue release];
		secondValue = [value copy];
	}
}

- (BOOL)validateSecondValue:(id *)ioValue error:(NSError **)outError
{
	return [self validateValue:ioValue error:outError];
}

- (int)thirdLabel
{
	return thirdLabel;
}

- (void)setThirdLabel:(int)value
{
	thirdLabel = value;
}

- (NSString *)thirdValue
{
	return thirdValue;
}

- (void)setThirdValue:(NSString *)value
{
	if (thirdValue != value) {
		[thirdValue release];
		thirdValue = [value copy];
	}
}

- (BOOL)validateThirdValue:(id *)ioValue error:(NSError **)outError
{
	return [self validateValue:ioValue error:outError];
}

- (unsigned)indexForPreferredValue
{
	return indexForPreferredValue;
}

- (void)setIndexForPreferredValue:(unsigned)index
{
	indexForPreferredValue = index;
}

- (int)preferredLabel
{
	switch ([self indexForPreferredValue]) {
		case 0: return [self firstLabel];
		case 1: return [self secondLabel];
		case 2: return [self thirdLabel];
		default: return 0;
	}
}

- (void)setPreferredLabel:(int)value
{
	switch ([self indexForPreferredValue]) {
		case 0: [self setFirstLabel:value]; break;
		case 1: [self setSecondLabel:value]; break;
		case 2: [self setThirdLabel:value]; break;
		//default: 
	}
}

- (NSString *)preferredValue
{
	switch ([self indexForPreferredValue]) {
		case 0: return [self firstValue];
		case 1: return [self secondValue];
		case 2: return [self thirdValue];
		default: return nil;
	}
}

- (void)setPreferredValue:(NSString *)value
{
	switch ([self indexForPreferredValue]) {
		case 0: [self setFirstValue:value]; break;
		case 1: [self setSecondValue:value]; break;
		case 2: [self setThirdValue:value]; break;
		//default: 
	}
}

- (BOOL)validatePreferredValue:(id *)ioValue error:(NSError **)outError
{
	return [self validateValue:ioValue error:outError];
}

#pragma mark imitation methods of ABMultiValue

- (int)labelAtIndex:(unsigned)index
{
	switch (index) {
		case 0: return [self firstLabel];
		case 1: return [self secondLabel];
		case 2: return [self thirdLabel];
		default: return 0;
	}
}

- (NSString *)valueAtIndex:(unsigned)index
{
	switch (index) {
		case 0: return [self firstValue];
		case 1: return [self secondValue];
		case 2: return [self thirdValue];
		default: return nil;
	}
}

- (void)setLabel:(int)value atIndex:(unsigned)index
{
	switch (index) {
		case 0: [self setFirstLabel:value]; break;
		case 1: [self setSecondLabel:value]; break;
		case 2: [self setThirdLabel:value]; break;
	}
}

- (void)setValue:(NSString *)value atIndex:(unsigned)index
{
	switch (index) {
		case 0: [self setFirstValue:value]; break;
		case 1: [self setSecondValue:value]; break;
		case 2: [self setThirdValue:value]; break;
	}
}

- (BOOL)addValue:(NSString *)value withLabel:(int)label preferred:(BOOL)flag
{
	if ([self validateValue:&value error:NULL]) {
		int i;
		for (i = 0; i < 3; i++) {
			if ([self valueAtIndex:i] == nil) {
				[self setLabel:label atIndex:i];
				[self setValue:value atIndex:i];
				if (flag) [self setIndexForPreferredValue:i];
				return YES;
			}
		}
	}
	return NO;
}

- (BOOL)addValue:(NSString *)value withLabelString:(NSString *)labelString preferred:(BOOL)flag
{
	if ([self validateValue:&value error:NULL]) {
		int i;
		for (i = 0; i < 3; i++) {
			if ([self valueAtIndex:i] == nil) {
				[self setLabelString:labelString atIndex:i];
				[self setValue:value atIndex:i];
				if (flag) [self setIndexForPreferredValue:i];
				return YES;
			}
		} 
	}
	return NO;
}


// Do nothing. Subclass must implement this method.
- (BOOL)validateValue:(id *)ioValue error:(NSError **)outError
{
	return YES;
}

// Do nothing. Subclass must implement this method.
- (NSString *)labelStringAtIndex:(unsigned)index
{
	return nil;
}

// Do nothing. Subclass must implement this method.
- (void)setLabelString:(NSString *)value atIndex:(unsigned)index
{
	return;
}

@end


@implementation AHKPhoneNumbers

- (id)init
{
	self = [super init];
	if (self != nil) {
		[self setFirstLabel:AHKOtherPhoneType];
		[self setSecondLabel:AHKOtherPhoneType];
		[self setThirdLabel:AHKOtherPhoneType];
	}
	return self;
}


- (BOOL)validateValue:(id *)ioValue error:(NSError **)outError
{
	if (*ioValue == nil) {
		return YES;
	}
	int length = [(NSString *)*ioValue length];
	if (length > kMaxLengthOfPhone) {
		//*ioValue = [*ioValue substringToIndex:64];
		length = kMaxLengthOfPhone;
	}
	
	unichar c;
	unichar convertedChar[length];
	int i, j = 0;
	for (i = 0; i < length; i++) {
		c = [*ioValue characterAtIndex:i];
		if (c == 0x0023 || // '#'
			c == 0x002a || // '*'
			//c == 0x002d || // '-'
			c == 0x0050 || // 'P'
			c >= 0x0030 && c <= 0x0039) {// '0-9'
			convertedChar[j] = c;
			j++;
		}
	}
	*ioValue = [NSString stringWithCharacters:convertedChar length:j];
	return YES;
}

// Do nothing. Subclass must implement this method.
- (NSString *)labelStringAtIndex:(unsigned)index
{
	switch ([self labelAtIndex:index]) {
		case AHKPHSPhoneType		: return @"PCS";
		case AHKCellularPhoneType	: return @"CELL";
		case AHKHomePhoneType		: return @"HOME";
		case AHKWorkPhoneType		: return @"WORK";
		case AHKFaxPhoneType		: return @"FAX";
		default						: return @"VOICE";
	}
}

// Do nothing. Subclass must implement this method.
- (void)setLabelString:(NSString *)value atIndex:(unsigned)index
{
	NSString *uppercaseString = [value uppercaseString];

	if ([uppercaseString isEqualToString:@"PCS"]) {
		[self setLabel:AHKPHSPhoneType atIndex:index];
	} else if ([uppercaseString isEqualToString:@"CELL"]) {
		[self setLabel:AHKCellularPhoneType atIndex:index];
	} else if ([uppercaseString isEqualToString:@"HOME"]) {
		[self setLabel:AHKHomePhoneType atIndex:index];
	} else if ([uppercaseString isEqualToString:@"WORK"]) {
		[self setLabel:AHKWorkPhoneType atIndex:index];
	} else if ([uppercaseString isEqualToString:@"FAX"]) {
		[self setLabel:AHKFaxPhoneType atIndex:index];
	} else {
		[self setLabel:AHKOtherPhoneType atIndex:index];
	}
}


@end


@implementation AHKEmailAddresses

- (id)init
{
	self = [super init];
	if (self != nil) {
		[self setFirstLabel:AHKOtherEmailType];
		[self setSecondLabel:AHKOtherEmailType];
		[self setThirdLabel:AHKOtherEmailType];
	}
	return self;
}

- (BOOL)validateValue:(id *)ioValue error:(NSError **)outError
{
	if (*ioValue == nil) {
		return YES;
	}
	int length = [(NSString *)*ioValue length];
	if (length > kMaxLengthOfEmail) {
		//*ioValue = [*ioValue substringToIndex:64];
		length = kMaxLengthOfEmail;
	}
	
	unichar c;
	unichar convertedChar[length];
	int i, j = 0;
	for (i = 0; i < length; i++) {
		c = [*ioValue characterAtIndex:i];
		if (c == 0x0020 || // ' '
			c == 0x0021 || // '!'
			c == 0x0027 || // '\''
			c >= 0x002c && c <= 0x003b || // ',' '-' '.' '/' '0-9' ':' ';'
			c >= 0x003f && c <= 0x005a || // '?' '@' 'A-Z'
			c == 0x005f || // '_'
			c >= 0x0061 && c <= 0x007a || // 'a-z'
			c == 0x007e) { // '~'
			convertedChar[j] = c;
			j++;
		}
//		if ([[NSCharacterSet alphanumericCharacterSet] characterIsMember:c]) {
//			convertedChar[j] = c;
//			j++;
//		}
	}
	*ioValue = [NSString stringWithCharacters:convertedChar length:j];
	return YES;
}

- (NSString *)labelStringAtIndex:(unsigned)index
{
	switch ([self labelAtIndex:index]) {
		case AHKPHSEmailType		: return @"PCS";
		case AHKCellularEmailType	: return @"CELL";
		case AHKHomeEmailType		: return @"HOME";
		case AHKWorkEmailType		: return @"WORK";
		case AHKSchoolEmailType		: return @"SCHOOL";
		default						: return @"INTERNET";
	}
}

- (void)setLabelString:(NSString *)value atIndex:(unsigned)index
{
	NSString *labelString = [value uppercaseString];
	
	if ([labelString isEqualToString:@"PCS"]) {
		[self setLabel:AHKPHSEmailType atIndex:index];
	} else if ([labelString isEqualToString:@"CELL"]) {
		[self setLabel:AHKCellularEmailType atIndex:index];
	} else if ([labelString isEqualToString:@"HOME"]) {
		[self setLabel:AHKHomeEmailType atIndex:index];
	} else if ([labelString isEqualToString:@"WORK"]) {
		[self setLabel:AHKWorkEmailType atIndex:index];
	} else if ([labelString isEqualToString:@"SCHOOL"]) {
		[self setLabel:AHKSchoolEmailType atIndex:index];
	} else {
		[self setLabel:AHKOtherEmailType atIndex:index];
	}
}


@end
